%%%-------------------------------------------------------------------
%%% @copyright (C) 2019, Aeternity Anstalt
%%%
%%%   === ===  N O T E :   This file is generated do not edit. === ===
%%%
%%% Source is in aeb_fate_generate_ops.erl
%%% @doc
%%%     Provides opcode defines.
%%% @end
%%%-------------------------------------------------------------------

%% FATE opcodes
-define('RETURN'                     , 16#00).
-define('RETURNR'                    , 16#01).
-define('CALL'                       , 16#02).
-define('CALL_R'                     , 16#03).
-define('CALL_T'                     , 16#04).
-define('CALL_GR'                    , 16#05).
-define('JUMP'                       , 16#06).
-define('JUMPIF'                     , 16#07).
-define('SWITCH_V2'                  , 16#08).
-define('SWITCH_V3'                  , 16#09).
-define('SWITCH_VN'                  , 16#0a).
-define('CALL_VALUE'                 , 16#0b).
-define('PUSH'                       , 16#0c).
-define('DUPA'                       , 16#0d).
-define('DUP'                        , 16#0e).
-define('POP'                        , 16#0f).
-define('INCA'                       , 16#10).
-define('INC'                        , 16#11).
-define('DECA'                       , 16#12).
-define('DEC'                        , 16#13).
-define('ADD'                        , 16#14).
-define('SUB'                        , 16#15).
-define('MUL'                        , 16#16).
-define('DIV'                        , 16#17).
-define('MOD'                        , 16#18).
-define('POW'                        , 16#19).
-define('STORE'                      , 16#1a).
-define('SHA3'                       , 16#1b).
-define('SHA256'                     , 16#1c).
-define('BLAKE2B'                    , 16#1d).
-define('LT'                         , 16#1e).
-define('GT'                         , 16#1f).
-define('EQ'                         , 16#20).
-define('ELT'                        , 16#21).
-define('EGT'                        , 16#22).
-define('NEQ'                        , 16#23).
-define('AND'                        , 16#24).
-define('OR'                         , 16#25).
-define('NOT'                        , 16#26).
-define('TUPLE'                      , 16#27).
-define('ELEMENT'                    , 16#28).
-define('SETELEMENT'                 , 16#29).
-define('MAP_EMPTY'                  , 16#2a).
-define('MAP_LOOKUP'                 , 16#2b).
-define('MAP_LOOKUPD'                , 16#2c).
-define('MAP_UPDATE'                 , 16#2d).
-define('MAP_DELETE'                 , 16#2e).
-define('MAP_MEMBER'                 , 16#2f).
-define('MAP_FROM_LIST'              , 16#30).
-define('MAP_SIZE'                   , 16#31).
-define('MAP_TO_LIST'                , 16#32).
-define('IS_NIL'                     , 16#33).
-define('CONS'                       , 16#34).
-define('HD'                         , 16#35).
-define('TL'                         , 16#36).
-define('LENGTH'                     , 16#37).
-define('NIL'                        , 16#38).
-define('APPEND'                     , 16#39).
-define('STR_JOIN'                   , 16#3a).
-define('INT_TO_STR'                 , 16#3b).
-define('ADDR_TO_STR'                , 16#3c).
-define('STR_REVERSE'                , 16#3d).
-define('STR_LENGTH'                 , 16#3e).
-define('BYTES_TO_INT'               , 16#3f).
-define('BYTES_TO_STR'               , 16#40).
-define('BYTES_CONCAT'               , 16#41).
-define('BYTES_SPLIT'                , 16#42).
-define('INT_TO_ADDR'                , 16#43).
-define('VARIANT'                    , 16#44).
-define('VARIANT_TEST'               , 16#45).
-define('VARIANT_ELEMENT'            , 16#46).
-define('BITS_NONEA'                 , 16#47).
-define('BITS_NONE'                  , 16#48).
-define('BITS_ALLA'                  , 16#49).
-define('BITS_ALL'                   , 16#4a).
-define('BITS_ALL_N'                 , 16#4b).
-define('BITS_SET'                   , 16#4c).
-define('BITS_CLEAR'                 , 16#4d).
-define('BITS_TEST'                  , 16#4e).
-define('BITS_SUM'                   , 16#4f).
-define('BITS_OR'                    , 16#50).
-define('BITS_AND'                   , 16#51).
-define('BITS_DIFF'                  , 16#52).
-define('BALANCE'                    , 16#53).
-define('ORIGIN'                     , 16#54).
-define('CALLER'                     , 16#55).
-define('BLOCKHASH'                  , 16#56).
-define('BENEFICIARY'                , 16#57).
-define('TIMESTAMP'                  , 16#58).
-define('GENERATION'                 , 16#59).
-define('MICROBLOCK'                 , 16#5a).
-define('DIFFICULTY'                 , 16#5b).
-define('GASLIMIT'                   , 16#5c).
-define('GAS'                        , 16#5d).
-define('ADDRESS'                    , 16#5e).
-define('GASPRICE'                   , 16#5f).
-define('LOG0'                       , 16#60).
-define('LOG1'                       , 16#61).
-define('LOG2'                       , 16#62).
-define('LOG3'                       , 16#63).
-define('LOG4'                       , 16#64).
-define('SPEND'                      , 16#65).
-define('ORACLE_REGISTER'            , 16#66).
-define('ORACLE_QUERY'               , 16#67).
-define('ORACLE_RESPOND'             , 16#68).
-define('ORACLE_EXTEND'              , 16#69).
-define('ORACLE_GET_ANSWER'          , 16#6a).
-define('ORACLE_GET_QUESTION'        , 16#6b).
-define('ORACLE_QUERY_FEE'           , 16#6c).
-define('AENS_RESOLVE'               , 16#6d).
-define('AENS_PRECLAIM'              , 16#6e).
-define('AENS_CLAIM'                 , 16#6f).
-define('AENS_UPDATE'                , 16#70).
-define('AENS_TRANSFER'              , 16#71).
-define('AENS_REVOKE'                , 16#72).
-define('BALANCE_OTHER'              , 16#73).
-define('VERIFY_SIG'                 , 16#74).
-define('VERIFY_SIG_SECP256K1'       , 16#75).
-define('CONTRACT_TO_ADDRESS'        , 16#76).
-define('AUTH_TX_HASH'               , 16#77).
-define('ORACLE_CHECK'               , 16#78).
-define('ORACLE_CHECK_QUERY'         , 16#79).
-define('IS_ORACLE'                  , 16#7a).
-define('IS_CONTRACT'                , 16#7b).
-define('IS_PAYABLE'                 , 16#7c).
-define('CREATOR'                    , 16#7d).
-define('ECVERIFY_SECP256K1'         , 16#7e).
-define('ECRECOVER_SECP256K1'        , 16#7f).
-define('ADDRESS_TO_CONTRACT'        , 16#80).
-define('BLS12_381_G1_NEG'           , 16#81).
-define('BLS12_381_G1_NORM'          , 16#82).
-define('BLS12_381_G1_VALID'         , 16#83).
-define('BLS12_381_G1_IS_ZERO'       , 16#84).
-define('BLS12_381_G1_ADD'           , 16#85).
-define('BLS12_381_G1_MUL'           , 16#86).
-define('BLS12_381_G2_NEG'           , 16#87).
-define('BLS12_381_G2_NORM'          , 16#88).
-define('BLS12_381_G2_VALID'         , 16#89).
-define('BLS12_381_G2_IS_ZERO'       , 16#8a).
-define('BLS12_381_G2_ADD'           , 16#8b).
-define('BLS12_381_G2_MUL'           , 16#8c).
-define('BLS12_381_GT_INV'           , 16#8d).
-define('BLS12_381_GT_ADD'           , 16#8e).
-define('BLS12_381_GT_MUL'           , 16#8f).
-define('BLS12_381_GT_POW'           , 16#90).
-define('BLS12_381_GT_IS_ONE'        , 16#91).
-define('BLS12_381_PAIRING'          , 16#92).
-define('BLS12_381_MILLER_LOOP'      , 16#93).
-define('BLS12_381_FINAL_EXP'        , 16#94).
-define('BLS12_381_INT_TO_FR'        , 16#95).
-define('BLS12_381_INT_TO_FP'        , 16#96).
-define('BLS12_381_FR_TO_INT'        , 16#97).
-define('BLS12_381_FP_TO_INT'        , 16#98).
-define('AENS_LOOKUP'                , 16#99).
-define('ORACLE_EXPIRY'              , 16#9a).
-define('AUTH_TX'                    , 16#9b).
-define('STR_TO_LIST'                , 16#9c).
-define('STR_FROM_LIST'              , 16#9d).
-define('STR_TO_UPPER'               , 16#9e).
-define('STR_TO_LOWER'               , 16#9f).
-define('CHAR_TO_INT'                , 16#a0).
-define('CHAR_FROM_INT'              , 16#a1).
-define('CALL_PGR'                   , 16#a2).
-define('CREATE'                     , 16#a3).
-define('CLONE'                      , 16#a4).
-define('CLONE_G'                    , 16#a5).
-define('BYTECODE_HASH'              , 16#a6).
-define('FEE'                        , 16#a7).
-define('ADDRESS_TO_BYTES'           , 16#a8).
-define('POSEIDON'                   , 16#a9).
-define('MULMOD'                     , 16#aa).
-define('BAND'                       , 16#ab).
-define('BOR'                        , 16#ac).
-define('BXOR'                       , 16#ad).
-define('BNOT'                       , 16#ae).
-define('BSL'                        , 16#af).
-define('BSR'                        , 16#b0).
-define('BYTES_SPLIT_ANY'            , 16#b1).
-define('BYTES_SIZE'                 , 16#b2).
-define('BYTES_TO_FIXED_SIZE'        , 16#b3).
-define('INT_TO_BYTES'               , 16#b4).
-define('STR_TO_BYTES'               , 16#b5).
-define('NETWORK_ID'                 , 16#b6).
-define('DBG_LOC'                    , 16#f0).
-define('DBG_DEF'                    , 16#f1).
-define('DBG_UNDEF'                  , 16#f2).
-define('DBG_CONTRACT'               , 16#f3).
-define('DEACTIVATE'                 , 16#fa).
-define('ABORT'                      , 16#fb).
-define('EXIT'                       , 16#fc).
-define('NOP'                        , 16#fd).
-define('FUNCTION'                , 16#fe).
-define('EXTEND'                  , 16#ff).

